/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.pushingpixels.lafwidget.contrib.intellij.JBHiDPIScaledImage;
import org.pushingpixels.lafwidget.contrib.intellij.UIUtil;
import org.pushingpixels.lafwidget.preview.PreviewPainter;
import org.pushingpixels.lafwidget.tabbed.TabPreviewPainter;
import org.pushingpixels.lafwidget.text.PasswordStrengthChecker;

public class LafWidgetUtilities2 {
    private LafWidgetUtilities2() {
    }

    public static TabPreviewPainter getTabPreviewPainter(JTabbedPane tabbedPane) {
        if (tabbedPane == null) {
            return null;
        }
        Object tabProp = tabbedPane.getClientProperty("lafwidgets.tabbedpanePreviewPainter");
        if (tabProp instanceof TabPreviewPainter) {
            return (TabPreviewPainter)tabProp;
        }
        return null;
    }

    public static PreviewPainter getComponentPreviewPainter(Component comp) {
        Object parentProp;
        Object compProp;
        if (comp == null) {
            return null;
        }
        if (comp instanceof JComponent && (compProp = ((JComponent)comp).getClientProperty("lafwidgets.componentPreviewPainter")) instanceof PreviewPainter) {
            return (PreviewPainter)compProp;
        }
        Container parent = comp.getParent();
        if (parent instanceof JComponent && (parentProp = ((JComponent)parent).getClientProperty("lafwidgets.componentPreviewPainter")) instanceof PreviewPainter) {
            return (PreviewPainter)parentProp;
        }
        Object globProp = UIManager.get("lafwidgets.componentPreviewPainter");
        if (globProp instanceof PreviewPainter) {
            return (PreviewPainter)globProp;
        }
        return null;
    }

    public static PasswordStrengthChecker getPasswordStrengthChecker(JPasswordField jpf) {
        Object obj = jpf.getClientProperty("lafwidgets.passwordStrengthChecker");
        if (obj != null && obj instanceof PasswordStrengthChecker) {
            return (PasswordStrengthChecker)obj;
        }
        return null;
    }

    public static BufferedImage getBlankImage(int width, int height) {
        if (UIUtil.isRetina()) {
            return new JBHiDPIScaledImage(width, height, 3);
        }
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        return c.createCompatibleImage(width, height, 3);
    }
}

