/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.pushingpixels.lafwidget.LafWidgetUtilities2;
import org.pushingpixels.lafwidget.contrib.intellij.JBHiDPIScaledImage;
import org.pushingpixels.lafwidget.contrib.intellij.UIUtil;
import org.pushingpixels.lafwidget.icon.IsHiDpiAware;
import org.pushingpixels.lafwidget.utils.ColorFilter;

public class HiDpiAwareIcon
implements Icon,
IsHiDpiAware {
    private final int factor;
    private final boolean isHiDpiAwareSource;
    private BufferedImage imageSource;
    private Icon iconSource;
    private int width;
    private int height;

    public HiDpiAwareIcon(BufferedImage image) {
        this.imageSource = image;
        this.factor = UIUtil.getScaleFactor();
        this.isHiDpiAwareSource = image instanceof JBHiDPIScaledImage;
        this.width = this.getInternalWidth();
        this.height = this.getInternalHeight();
    }

    public HiDpiAwareIcon(Icon icon) {
        this.iconSource = icon;
        this.factor = UIUtil.getScaleFactor();
        this.isHiDpiAwareSource = icon instanceof IsHiDpiAware && ((IsHiDpiAware)((Object)icon)).isHiDpiAware();
        this.width = this.getInternalWidth();
        this.height = this.getInternalHeight();
    }

    public void setDimension(int width, int height) {
        if (this.getIconWidth() > width || this.getIconHeight() > height) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean isHiDpiAware() {
        return this.isHiDpiAwareSource;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        int dx = (this.width - this.getInternalWidth()) / 2;
        int dy = (this.height - this.getInternalHeight()) / 2;
        g2d.translate(x + dx, y + dy);
        if (this.imageSource != null) {
            g2d.drawImage(this.imageSource, 0, 0, this.imageSource.getWidth() / this.factor, this.imageSource.getHeight() / this.factor, null);
        } else if (this.iconSource != null) {
            this.iconSource.paintIcon(c, g2d, 0, 0);
        }
        g2d.dispose();
    }

    private int getInternalWidth() {
        if (this.imageSource != null) {
            return this.imageSource.getWidth() / this.factor;
        }
        if (this.iconSource != null) {
            return this.iconSource.getIconWidth() / (this.isHiDpiAwareSource ? 1 : this.factor);
        }
        return 0;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    private int getInternalHeight() {
        if (this.imageSource != null) {
            return this.imageSource.getHeight() / this.factor;
        }
        if (this.iconSource != null) {
            return this.iconSource.getIconHeight() / (this.isHiDpiAwareSource ? 1 : this.factor);
        }
        return 0;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public int getFactor() {
        return this.factor;
    }

    public BufferedImage toImage() {
        BufferedImage result = LafWidgetUtilities2.getBlankImage(this.getIconWidth(), this.getIconHeight());
        this.paintIcon(null, result.getGraphics(), 0, 0);
        return result;
    }

    public HiDpiAwareIcon colorize(Color color) {
        return new HiDpiAwareIcon(new ColorFilter(color).filter(this.toImage(), null));
    }
}

