/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.utils;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.pushingpixels.lafwidget.utils.AbstractFilter;

public class ColorFilter
extends AbstractFilter {
    private int color;

    public ColorFilter(Color color) {
        this.color = color.getRGB();
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        this.getPixels(src, 0, 0, width, height, pixels);
        int colorAlpha = this.color >>> 24 & 0xFF;
        int colorRed = this.color >>> 16 & 0xFF;
        int colorGreen = this.color >>> 8 & 0xFF;
        int colorBlue = this.color & 0xFF;
        int i = 0;
        while (i < pixels.length) {
            int alpha = (pixels[i] >>> 24 & 0xFF) * colorAlpha / 256;
            pixels[i] = alpha << 24 | colorRed << 16 | colorGreen << 8 | colorBlue;
            ++i;
        }
        this.setPixels(dst, 0, 0, width, height, pixels);
        return dst;
    }
}

