/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.stream.ImageInputStream;
import org.apache.felix.framework.util.Util;

public class FileUtil {
    public static final int FILE_BUFFER = 4096;

    public static void safeClose(Closeable object) {
        try {
            if (object != null) {
                object.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void safeClose(ImageInputStream stream) {
        try {
            if (stream != null) {
                stream.flush();
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void recursiveDelete(File rootDir, boolean deleteRoot) {
        if (rootDir == null || !rootDir.isDirectory()) {
            return;
        }
        File[] childDirs = rootDir.listFiles();
        if (childDirs != null) {
            for (File f : childDirs) {
                if (f.isDirectory()) {
                    FileUtil.recursiveDelete(f, false);
                    FileUtil.deleteFile(f);
                    continue;
                }
                FileUtil.deleteFile(f);
            }
        }
        if (deleteRoot) {
            rootDir.delete();
        }
    }

    public static final void deleteDirectoryContents(File dir, int deleteDirLevel, int level) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileUtil.deleteDirectoryContents(f, deleteDirLevel, level + 1);
                    continue;
                }
                FileUtil.deleteFile(f);
            }
        }
        if (level >= deleteDirLevel) {
            FileUtil.deleteFile(dir);
        }
    }

    private static void deleteFile(File fileOrDirectory) {
        try {
            fileOrDirectory.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static File getApplicationTempDir() {
        File tdir;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null || tempDir.length() == 1) {
            String dir = System.getProperty("user.home", "");
            tdir = new File(dir);
        } else {
            tdir = new File(tempDir);
        }
        return new File(tdir, "weasis-" + System.getProperty("user.name", "tmp"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void storeProperties(File propsFile, Properties props, String comments) {
        if (props != null && propsFile != null) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(propsFile);
                props.store(fout, comments);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                FileUtil.safeClose(fout);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        FileUtil.safeClose(fout);
                        throw throwable;
                    }
                }
                FileUtil.safeClose(fout);
            }
            FileUtil.safeClose(fout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(InputStream inputStream, OutputStream out) {
        if (inputStream == null || out == null) {
            return;
        }
        try {
            int offset;
            byte[] buf = new byte[4096];
            while ((offset = inputStream.read(buf)) > 0) {
                out.write(buf, 0, offset);
            }
            out.flush();
        }
        catch (IOException e) {
            System.err.println("Error when writing file");
        }
        finally {
            FileUtil.safeClose(inputStream);
            FileUtil.safeClose(out);
        }
    }

    public static String writeResources(String srcPath, File cacheDir, String date) throws Exception {
        String fileDate = null;
        URLConnection urlConnection = FileUtil.getAdaptedConnection(new URL(srcPath));
        long last = urlConnection.getLastModified();
        if (last != 0L) {
            fileDate = Long.toString(last);
        }
        if (!cacheDir.canRead() || date == null || !date.equals(fileDate)) {
            FileUtil.recursiveDelete(cacheDir, false);
            FileUtil.unzip(urlConnection.getInputStream(), cacheDir);
        }
        return fileDate;
    }

    public static URLConnection getAdaptedConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        String auth = System.getProperty("http.proxyAuth", null);
        if (auth != null && auth.length() > 0 && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
            String base64 = Util.base64Encode((String)auth);
            connection.setRequestProperty("Proxy-Authorization", "Basic " + base64);
        }
        return connection;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int offset;
        if (in == null || out == null) {
            return;
        }
        byte[] buf = new byte[4096];
        while ((offset = in.read(buf)) > 0) {
            out.write(buf, 0, offset);
        }
        out.flush();
    }

    private static void copyZip(InputStream in, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            FileUtil.copy(in, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream inputStream, File directory) throws IOException {
        if (inputStream == null || directory == null) {
            return;
        }
        try (BufferedInputStream bufInStream = new BufferedInputStream(inputStream);
             ZipInputStream zis = new ZipInputStream(bufInStream);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(directory, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                FileUtil.copyZip(zis, file);
            }
        }
        finally {
            FileUtil.safeClose(inputStream);
        }
    }
}

