/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.IIORegistry;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import org.weasis.launcher.WeasisLauncher;

public class WebstartLauncher
extends WeasisLauncher
implements SingleInstanceListener {
    private static final Logger LOGGER = Logger.getLogger(WebstartLauncher.class.getName());
    private static final WebstartLauncher instance = new WebstartLauncher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newActivation(String[] argv) {
        WebstartLauncher webstartLauncher = this;
        synchronized (webstartLauncher) {
            int loop = 0;
            boolean runLoop = true;
            while (runLoop && !frameworkLoaded) {
                try {
                    TimeUnit.MILLISECONDS.sleep(200L);
                    if (++loop <= 100) continue;
                    runLoop = false;
                }
                catch (InterruptedException e) {
                    runLoop = false;
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (m_tracker != null && argv.length > 0) {
            WebstartLauncher.executeCommands(WebstartLauncher.splitCommand(argv), null);
        }
    }

    public static void launch(String[] argv) throws Exception {
        WeasisLauncher.launch(argv);
    }

    public static void main(String[] argv) throws Exception {
        WebstartLauncher.launch(argv);
    }

    static {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener((SingleInstanceListener)instance);
        }
        catch (UnavailableServiceException e) {
            LOGGER.log(Level.SEVERE, "Unable to get SingleInstanceService", e);
        }
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<Class<?>> categories = registry.getCategories();
        ArrayList toRemove = new ArrayList();
        while (categories.hasNext()) {
            Class<?> class1 = categories.next();
            Iterator<?> providers = registry.getServiceProviders(class1, false);
            while (providers.hasNext()) {
                Object provider = providers.next();
                if (!provider.getClass().getPackage().getName().startsWith("com.sun.media")) continue;
                toRemove.add(provider);
            }
        }
        for (Object provider : toRemove) {
            registry.deregisterServiceProvider(provider);
        }
    }
}

