﻿# Prompt operativo â€” Roadmap agenti multiprofilo ("dockerâ€‘like")

Stato: COMPLETATO (2025-10-08)


Obiettivo: rendere semplice creare e avviare agenti paralleli ma isolati (es. "aurelio", "seneca"), ciascuno con proprie memorie e prompt, avviabili su porte diverse.

## Sequenza Operativa (ordinata)

0) Aurelio â€” piccoli fix (prima di duplicare)
- Messaggio piÃ¹ chiaro quando satura i passi: se lâ€™output Ã¨ "Agent stopped due to iteration/time limit", restituisci un messaggio guidato allâ€™utente (es. "risposta non conclusa, riprova o riformula").
- Toggle debug degli step: aggiungi un flag in config per abilitare `return_intermediate_steps` e loggare tool/latency durante i test.
- Accettazione: prompt/UX invariati, messaggi piÃ¹ chiari in saturazione; toggle disattivo di default.

1) Parametrizza percorsi memoria RAG (docstore)
- In `services/cognitiveservice/cognitiveservice.py` rendi configurabile anche `docstore_path` (oggi Ã¨ fissato a `doc_store`).
- Leggilo da config: `self.config.get('docstore_path', 'doc_store')` e passa tramite `self.core.get_data_path(...)` come per `vectorstore_path` e `chat_memory_db`.
- Accettazione: Aurelio continua a funzionare come oggi con i default; nessuna regressione.

2) Selezione profilo/porta via variabili dâ€™ambiente
- In `api/api_server.py` leggi le env `AGENT_PROFILE` (default `aurelio`) e `PORT` (default `8000`).
- Istanzia il Kernel con `profile_name=os.getenv('AGENT_PROFILE','aurelio')` e avvia Uvicorn su `PORT`.
- Accettazione: avvio esplicito di profili e porte senza toccare il codice.

3) Indicizzatore con destinazione per profilo
- In `scripts/indicizza_documenti.py` aggiungi `--vectorstore` e `--docstore` (oppure leggi `AGENT_PROFILE`) per indirizzare le cartelle corrette.
- Mantieni compatibilitÃ  con i default attuali se gli argomenti non sono passati.
- Accettazione: indicizzatore funziona per Aurelio e per i nuovi profili.

4) Aggiungi profilo agente secondario (es. `seneca`)
- In `config/config.yaml` crea il profilo con percorsi dedicati:
  - `vectorstore_path: "agents/seneca/chroma_db"`
  - `docstore_path: "agents/seneca/doc_store"`
  - `chat_memory_db: "agents/seneca/memoria_chat.sqlite"`
  - prompt/tool name minimi dedicati (copia base).
- Accettazione: file di config valido; nessun impatto su `aurelio`.

5) Documentazione e avvio parallelo (stile "docker-like")
- Aggiorna `README_[ai].md` con esempi dâ€™avvio:
  - `AGENT_PROFILE=aurelio PORT=8000 start_api.bat`
  - `AGENT_PROFILE=seneca  PORT=8001 start_api.bat`
- Nota: ogni profilo usa memorie separate sotto `data/agents/<nome>/...`.
- Accettazione: doc aggiornata, istruzioni concise.

6) Test di verifica (due istanze)
- Avvia le due istanze su porte diverse; verifica `/` e `/ask` su entrambe.
- Conferma che le memorie restino separate (chat e RAG) con domande diverse.
- Accettazione: test manuale verde; latenza nella norma.

7) Migliorie riusabili (post-profili)
- Retrieval: abilita MMR nel retriever (`search_kwargs={"k":5,"fetch_k":20,"lambda_mult":0.5}`) per miglior precisione.
- Citazioni: includi id/pagina (metadati) nelle risposte RAG per tracciabilitÃ .
- Indicizzazione bulk: script per indicizzare una cartella di PDF per profilo.
- (Opz.) OsservabilitÃ : metriche semplici su tool calls (latency, errori) nei log.
- Accettazione: nessuna regressione su Aurelio; benefici misurabili su corpora piÃ¹ ampi.

Istruzioni per lâ€™assistente (esegui in ordine, confermando dopo ogni step):

1) Parametrizza percorsi memoria RAG
- In `services/cognitiveservice/cognitiveservice.py` rendi configurabile anche `docstore_path` (oggi Ã¨ fissato a `doc_store`).
- Leggilo da config: `self.config.get('docstore_path', 'doc_store')` e usa `self.core.get_data_path(...)` come giÃ  per `vectorstore_path` e `chat_memory_db`.

2) Aggiungi profilo agente secondario
- In `config/config.yaml` aggiungi il profilo `seneca` con percorsi dedicati:
  - `vectorstore_path: "agents/seneca/chroma_db"`
  - `docstore_path: "agents/seneca/doc_store"`
  - `chat_memory_db: "agents/seneca/memoria_chat.sqlite"`
  - prompt/tool name proprio (basta una copia di base; contenuti minimi).

3) Selezione profilo e porta via env
- In `api/api_server.py` leggi le env `AGENT_PROFILE` (default `aurelio`) e `PORT` (default `8000`).
- Istanzia il Kernel con `profile_name=os.getenv('AGENT_PROFILE', 'aurelio')`.
- Avvia Uvicorn sulla porta letta da `PORT`.

4) Indicizzatore con destinazione per profilo
- In `scripts/indicizza_documenti.py` accetta argomenti opzionali `--vectorstore` e `--docstore` (o, in alternativa, leggi `AGENT_PROFILE` e instrada su `data/agents/<profile>/...`).
- Mantieni la compatibilitÃ : se non passati, usa i default attuali.

5) Documentazione di avvio parallelo
- Aggiorna `README_[ai].md` con esempi dâ€™avvio:
  - `AGENT_PROFILE=aurelio PORT=8000 start_api.bat`
  - `AGENT_PROFILE=seneca  PORT=8001 start_api.bat`
- Nota: ogni profilo usa memorie separate (RAG e chat) sotto `data/agents/<nome>/...`.

6) Test di verifica
- Avvia due istanze su porte diverse; verifica `/` e `/ask` su entrambe.
- Conferma che le memorie non si mescolino (domande diverse, storie separate, RAG distinto).

7) Migliorie opzionali e riusabili (post-profili)
- Retrieval: abilita MMR nel retriever (`search_kwargs={"k": 5, "fetch_k": 20, "lambda_mult": 0.5}`).
- Citazioni: includi in output id/pagina dei passaggi citati (metadati doc) nelle risposte RAG.
- Script bulk: aggiungi uno script per indicizzare una cartella di PDF in blocco per un profilo.

Accettazione (Done quando):
- [x] `docstore_path` configurabile via YAML e usato dal servizio.
- [x] Profilo `seneca` presente in `config/config.yaml` con percorsi isolati.
- [x] `api/api_server.py` avvia il profilo richiesto da env e ascolta sulla porta specificata.
- [x] Indicizzatore accetta destinazioni o instrada per profilo senza rompere i default.
- [x] Avvio parallelo di due agenti funziona; memorie (RAG/chat) restano separate.

Completamenti aggiuntivi oltre all'accettazione originale:
- [x] Punto 0: messaggio chiaro su saturazione passi/tempo e toggle `debug_intermediate_steps` per loggare tool/latency.
- [x] Punto 7: MMR sul retriever (best‑effort), citazioni con fonte/pagina nelle risposte RAG, script bulk `scripts/indicizza_cartella.py`.
- [x] Avvio rapido per profilo: `start_aurelio.bat`, `start_seneca.bat` e UI puntata al backend via `JARVIS_API_BASE_URL`.
- [x] Containerizzazione completa percorsi di Aurelio in `data/agents/aurelio/...` (con migrazione automatizzata e fallback legacy).
- [x] Archiviazione dei PDF sorgenti per profilo in `data/agents/<profilo>/source_docs/` (default ON, dedup per hash).
- [x] Smoke test E2E stabilizzato (`tests/smoke_api.py`).

