@echo off
TITLE Jarvis-Cognitive API Launcher

echo =========================================
echo  LANCIATORE JARVIS-COGNITIVE (MODALITA' API)
echo =========================================
echo.
echo Questo script avviera' il Backend API e la UI
echo in due finestre di terminale separate.
echo.
echo Il Backend (API Server) e' il cervello di Jarvis.
echo La UI (Streamlit) e' l'interfaccia per parlare con lui.
echo.
echo Chiudi le singole finestre per fermare
echo i rispettivi processi.
echo.
echo =========================================
pause
echo.

REM Controlla se l'ambiente virtuale esiste
IF NOT EXIST .\.venv\Scripts\activate (
    echo ERRORE: Ambiente virtuale .venv non trovato.
    echo Esegui prima 'python -m venv .venv' e 'pip install -r requirements.txt'
    pause
    exit /b
)

echo Avvio del Backend API in una nuova finestra...
start "Jarvis Backend (API)" cmd /c "call .\.venv\Scripts\activate && python api/api_server.py && pause"

echo Attesa di 8 secondi per permettere al backend di avviarsi e caricare i modelli...
timeout /t 8 /nobreak >nul

echo.
echo Avvio della UI (Streamlit) in una nuova finestra...
start "Jarvis UI" cmd /c "call .\.venv\Scripts\activate && streamlit run ui/dashboard.py && pause"

echo.
echo Avvio completato.