# Jarvis-Cognitive/core/cognitive_engine/agent.py

from langchain_chroma import Chroma
from langchain_google_genai import GoogleGenerativeAIEmbeddings
from langchain.agents import AgentExecutor, create_tool_calling_agent
from langchain_core.prompts import ChatPromptTemplate, MessagesPlaceholder
from .tools import get_tools

class AgenteFinale:
    # --- MODIFICA 1: Aggiunto `vectorstore_path` al costruttore ---
    def __init__(self, llm, system_prompt: str, vectorstore_path: str):
        print(f"Inizializzazione Agente. Percorso Vector Store: {vectorstore_path}")
        self.llm = llm
        
        # --- MODIFICA 2: Il percorso non è più hardcoded ---
        embeddings = GoogleGenerativeAIEmbeddings(model="models/embedding-001")
        vectorstore = Chroma(persist_directory=vectorstore_path, embedding_function=embeddings)
        # --- FINE MODIFICA ---

        retriever = vectorstore.as_retriever(search_kwargs={"k": 3})
        tools = get_tools(self.llm, retriever)
        
        prompt = ChatPromptTemplate.from_messages([
            ("system", system_prompt),
            MessagesPlaceholder(variable_name="chat_history", optional=True),
            ("human", "{input}"),
            MessagesPlaceholder(variable_name="agent_scratchpad"),
        ])

        agent = create_tool_calling_agent(self.llm, tools, prompt)

        self.agent_executor = AgentExecutor(
            agent=agent, 
            tools=tools, 
            verbose=True,
            handle_parsing_errors=True,
            max_iterations=5 
        )
        
        print("Agente (tool-calling) pronto.")