# core/service_base.py

class ServiceBase:
    """
    Classe base astratta per tutti i servizi di Jarvis.
    Definisce l'interfaccia comune che il Kernel si aspetta.
    """
    def __init__(self, kernel, config: dict):
        """
        Inizializza il servizio.

        Args:
            kernel: L'istanza del Kernel di Jarvis, per accedere alle API del kernel.
            config: La sezione di configurazione specifica per questo servizio.
        """
        self._kernel = kernel
        self.config = config

    def start(self):
        """
        Metodo chiamato dal Kernel all'avvio.
        Le sottoclassi dovrebbero implementare qui la loro logica di inizializzazione.
        """
        pass

    def stop(self):
        """
        Metodo chiamato dal Kernel all'arresto.
        Le sottoclassi dovrebbero implementare qui la loro logica di pulizia.
        """
        pass

    def log(self, message, level='info'):
        """
        Metodo di utilità per loggare messaggi tramite il sistema di logging del Kernel.
        """
        # Usa l'API di logging del kernel per mantenere i log centralizzati.
        self._kernel.log(message, level)