import os
import sys
import argparse
import subprocess


def main():
    parser = argparse.ArgumentParser(description="Indicizza tutti i PDF/TXT in una cartella per un profilo.")
    parser.add_argument("directory", help="Cartella contenente i file da indicizzare")
    parser.add_argument("--profile", default=None, help="Profilo agente (default: da env/config)")
    parser.add_argument("--no-save-source", dest="save_source", action="store_false", help="Non salvare copia sorgente")
    parser.set_defaults(save_source=True)

    args = parser.parse_args()
    dir_path = os.path.abspath(args.directory)
    if not os.path.isdir(dir_path):
        print(f"Errore: cartella non trovata: {dir_path}")
        sys.exit(1)

    project_root = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
    indicizza = os.path.join(project_root, "scripts", "indicizza_documenti.py")

    exts = {".pdf", ".txt"}
    files = [os.path.join(dir_path, f) for f in os.listdir(dir_path) if os.path.splitext(f)[1].lower() in exts]
    if not files:
        print("Nessun file .pdf/.txt trovato nella cartella.")
        return

    print(f"Trovati {len(files)} file da indicizzare in: {dir_path}")
    for fp in files:
        cmd = [sys.executable, indicizza, fp]
        if args.profile:
            cmd += ["--profile", args.profile]
        if not args.save_source:
            cmd += ["--no-save-source"]
        print("\n>>> Indicizzo:", os.path.basename(fp))
        res = subprocess.run(cmd)
        if res.returncode != 0:
            print(f"[ERRORE] Indicizzazione fallita per: {fp}")

if __name__ == "__main__":
    main()

