# Jarvis-Cognitive/core/cognitive_engine/agent.py (v_refactored_for_tools)

from langchain_chroma import Chroma
from langchain_google_genai import GoogleGenerativeAIEmbeddings
from langchain.agents import AgentExecutor, create_tool_calling_agent
from langchain_core.prompts import ChatPromptTemplate, MessagesPlaceholder

# Non useremo più i parser e format custom, ma quelli integrati nella factory dell'agente
# from langchain.agents.format_scratchpad.tools import format_to_tool_messages
# from langchain.agents.output_parsers.tools import ToolsAgentOutputParser

from .tools import get_tools

class AgenteFinale:
    def __init__(self, llm, system_prompt: str):
        print("Inizializzazione Agente con architettura 'create_tool_calling_agent'...")
        self.llm = llm
        
        vectorstore_path = "data/chroma_db"
        embeddings = GoogleGenerativeAIEmbeddings(model="models/embedding-001")
        vectorstore = Chroma(persist_directory=vectorstore_path, embedding_function=embeddings)
        retriever = vectorstore.as_retriever(search_kwargs={"k": 3})

        # --- MODIFICA 1: Gli strumenti rimangono gli stessi ---
        tools = get_tools(self.llm, retriever)
        
        # --- MODIFICA 2: Costruiamo il prompt in modo più standard ---
        # Questo prompt è specificamente progettato per gli agenti tool-calling
        prompt = ChatPromptTemplate.from_messages([
            ("system", system_prompt),
            MessagesPlaceholder(variable_name="chat_history", optional=True),
            ("human", "{input}"),
            MessagesPlaceholder(variable_name="agent_scratchpad"),
        ])

        # --- MODIFICA 3 (LA PIÙ IMPORTANTE): Usiamo una factory di LangChain ---
        # Invece di costruire la catena LCEL manualmente, usiamo 'create_tool_calling_agent'.
        # Questa funzione è ottimizzata per assicurare che il modello e gli strumenti
        # siano "cablati" insieme nel modo corretto.
        agent = create_tool_calling_agent(self.llm, tools, prompt)

        # --- MODIFICA 4: L'AgentExecutor rimane, ma ora orchestra la nuova factory ---
        self.agent_executor = AgentExecutor(
            agent=agent, 
            tools=tools, 
            verbose=True,
            handle_parsing_errors=True,
            # Aggiungiamo un limite al numero di passaggi per evitare loop infiniti
            max_iterations=5 
        )
        
        print("Agente (tool-calling) pronto.")