@echo off
TITLE Jarvis-Cognitive - Aurelio

echo =========================================
echo  AVVIO PROFILO: AURELIO
echo =========================================
echo.

REM Configura variabili per il profilo Aurelio
set AGENT_PROFILE=aurelio
set PORT=8000
set JARVIS_API_BASE_URL=http://127.0.0.1:8000

REM Controlla se l'ambiente virtuale esiste
IF NOT EXIST .\.venv\Scripts\activate (
    echo ERRORE: Ambiente virtuale .venv non trovato.
    echo Esegui prima 'python -m venv .venv' e 'pip install -r requirements.txt'
    pause
    exit /b
)

echo Avvio del Backend API (Aurelio) in una nuova finestra...
start "Jarvis Backend (API) - Aurelio" cmd /c "call .\.venv\Scripts\activate && python api/api_server.py && pause"

echo Attesa di 8 secondi per permettere al backend di avviarsi...
timeout /t 8 /nobreak >nul

echo Avvio della UI (Streamlit) per Aurelio in una nuova finestra...
start "Jarvis UI - Aurelio" cmd /c "call .\.venv\Scripts\activate && streamlit run ui/dashboard.py --server.port 8501 && pause"

echo.
echo Avvio completato per il profilo AURELIO.

