# Jarvis-Cognitive/core/cognitive_engine/tools.py (v_simplified_env_loading)

import os
from langchain.tools import tool
from langchain.chains import RetrievalQA
from langchain_tavily import TavilySearch

def get_tools(llm, retriever):
    """
    Crea e restituisce una lista di strumenti disponibili.
    Ora si affida al caricamento delle variabili d'ambiente globale
    eseguito dal launcher principale (jarvis.py).
    """

    # Strumento 1: Ricerca Documentale (RAG)
    @tool
    def ricerca_documentale(query: str) -> str:
        """
        La tua fonte primaria di conoscenza. Usala SEMPRE per rispondere a domande
        sulla filosofia stoica, sui tuoi pensieri, sulla virtù, la ragione, la morte,
        e su qualsiasi concetto contenuto nei tuoi scritti (le Meditazioni).
        Questa è la tua memoria interna e la tua saggezza.
        """
        rag_chain = RetrievalQA.from_chain_type(llm, retriever=retriever)
        result = rag_chain.invoke({"query": query})
        return result["result"]

    # Strumento 2: Ricerca Web (Tavily)
    # Ora non passiamo più la chiave esplicitamente. LangChain la cercherà
    # automaticamente nella variabile d'ambiente TAVILY_API_KEY.
    tavily_tool = TavilySearch(
        name="Ricerca_Web_e_Calcolatrice_Avanzata",
        description="""La tua finestra sul mondo moderno. Usalo per trovare informazioni
che NON sono contenute nei tuoi scritti filosofici. È essenziale per:
- Dati in tempo reale (es. prezzi di azioni, meteo, tassi di cambio).
- Informazioni su persone, luoghi o eventi successivi alla tua epoca.
- Notizie e fatti del mondo attuale.
- Calcoli matematici."""
    )

    # Restituiamo la lista finale degli strumenti
    return [ricerca_documentale, tavily_tool]