# Jarvis-Cognitive/jarvis.py (v_env_loader)

import sys
import os
import time

# --- MODIFICA CHIAVE: Caricamento delle variabili d'ambiente ---
# Questo blocco viene eseguito PRIMA di qualsiasi import dal nostro progetto.
# Assicura che le chiavi API siano disponibili globalmente nell'ambiente
# del processo prima che LangChain o altre librerie vengano inizializzate.
from dotenv import load_dotenv
env_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'data', '.env')

if os.path.exists(env_path):
    print(f"[LAUNCHER] Caricamento variabili d'ambiente da: {env_path}")
    load_dotenv(dotenv_path=env_path)
else:
    print(f"[LAUNCHER] ATTENZIONE: File .env non trovato. I servizi che richiedono API keys falliranno.")
# --- FINE MODIFICA ---


# Aggiunge la directory principale di Jarvis al path di Python per permettere
# import come 'from core.kernel import JarvisKernel'
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

from core.kernel import JarvisKernel

def console_logger(log_data):
    """
    Callback per l'evento 'log:new_message'.
    Riceve i dati del log e li stampa sulla console.
    """
    message = log_data.get('message', '')
    level = log_data.get('level', 'info').upper()
    print(f"{message}") # Stampiamo direttamente il messaggio per pulizia

if __name__ == "__main__":
    config_path = os.path.join(os.path.dirname(__file__), 'config', 'config.yaml')
    
    # 1. Crea l'istanza del Kernel.
    kernel = JarvisKernel(config_path=config_path)
    
    # 2. Iscrive il nostro logger della console all'evento di log del Kernel.
    kernel.subscribe_to_event("log:new_message", console_logger)
    
    # 3. Avvia il Kernel e, di conseguenza, tutti i servizi.
    kernel.start()

    # 4. Mantiene il processo principale vivo per permettere ai thread dei servizi di funzionare.
    print("[LAUNCHER] Jarvis è in esecuzione in modalità headless. Premi Ctrl+C per fermare.")
    try:
        while True:
            time.sleep(1)
    except KeyboardInterrupt:
        print("\n[LAUNCHER] Segnale di interruzione ricevuto. Arresto di Jarvis...")
        kernel.stop()
        print("[LAUNCH-ER] Jarvis fermato.")