/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.contrib.intellij;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import org.pushingpixels.lafwidget.utils.LookUtils;

public class UIUtil {
    private static Boolean cachedRetinaReply = null;

    public static boolean isRetina(Graphics2D graphics) {
        if (LookUtils.IS_OS_MAC) {
            return DetectRetinaKit.isMacRetina(graphics);
        }
        return UIUtil.isRetina();
    }

    public static boolean isRetina() {
        if (cachedRetinaReply != null) {
            return cachedRetinaReply;
        }
        boolean result = false;
        result = GraphicsEnvironment.isHeadless() ? false : ("true".equalsIgnoreCase(System.getProperty("is.hidpi")) ? true : DetectRetinaKit.isRetina());
        cachedRetinaReply = result;
        return cachedRetinaReply;
    }

    public static int getScaleFactor() {
        return UIUtil.isRetina() ? 2 : 1;
    }

    private static final class DetectRetinaKit {
        private static final WeakHashMap<GraphicsDevice, Boolean> devicesToRetinaSupportCacheMap = new WeakHashMap();

        private DetectRetinaKit() {
        }

        private static boolean isOracleMacRetinaDeviceModern(GraphicsDevice device) {
            GraphicsConfiguration graphicsConfig = device.getDefaultConfiguration();
            AffineTransform tx = graphicsConfig.getDefaultTransform();
            double scaleX = tx.getScaleX();
            double scaleY = tx.getScaleY();
            return scaleX > 1.0 && scaleY > 1.0;
        }

        private static boolean isOracleMacRetinaDeviceLegacy(GraphicsDevice device) {
            try {
                Method getScaleFactorMethod = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
                return getScaleFactorMethod == null || (Integer)getScaleFactorMethod.invoke((Object)device, new Object[0]) != 1;
            }
            catch (Throwable t) {
                return false;
            }
        }

        private static boolean isOracleMacRetinaDevice(GraphicsDevice device) {
            if (LookUtils.IS_VENDOR_APPLE) {
                return false;
            }
            Boolean isRetina = devicesToRetinaSupportCacheMap.get(device);
            if (isRetina != null) {
                return isRetina;
            }
            isRetina = LookUtils.IS_JAVA_9 ? DetectRetinaKit.isOracleMacRetinaDeviceModern(device) : DetectRetinaKit.isOracleMacRetinaDeviceLegacy(device);
            devicesToRetinaSupportCacheMap.put(device, isRetina);
            return isRetina;
        }

        private static boolean hasAppleRetinaDevice() {
            return ((Float)Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor")).floatValue() != 1.0f;
        }

        private static boolean isMacRetina(Graphics2D g) {
            GraphicsDevice device = g.getDeviceConfiguration().getDevice();
            return DetectRetinaKit.isOracleMacRetinaDevice(device);
        }

        private static boolean isRetina() {
            if (LookUtils.IS_VENDOR_APPLE) {
                return DetectRetinaKit.hasAppleRetinaDevice();
            }
            if (LookUtils.IS_OS_MAC) {
                GraphicsDevice[] devices;
                GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] graphicsDeviceArray = devices = e.getScreenDevices();
                int n = devices.length;
                int n2 = 0;
                while (n2 < n) {
                    GraphicsDevice device = graphicsDeviceArray[n2];
                    if (DetectRetinaKit.isOracleMacRetinaDevice(device)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

