/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.preview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JViewport;
import org.pushingpixels.substance.api.painter.preview.PreviewPainter;
import org.pushingpixels.substance.internal.contrib.intellij.UIUtil;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class DefaultPreviewPainter
extends PreviewPainter {
    @Override
    public boolean hasPreview(Container parent, Component component, int componentIndex) {
        return component != null;
    }

    @Override
    public void previewComponent(Container parent, Component component, int componentIndex, Graphics g, int x, int y, int w, int h) {
        if (component == null) {
            return;
        }
        int compWidth = component.getWidth();
        int compHeight = component.getHeight();
        if (compWidth > 0 && compHeight > 0) {
            BufferedImage tempCanvas = new BufferedImage(compWidth, compHeight, 2);
            Graphics tempCanvasGraphics = tempCanvas.getGraphics();
            component.paint(tempCanvasGraphics);
            double scaleFactor = UIUtil.getScaleFactor();
            double coef = Math.min((double)w / (double)compWidth, (double)h / (double)compHeight) / scaleFactor;
            if (coef < 1.0) {
                int sdWidth = (int)(coef * (double)compWidth);
                int sdHeight = (int)(coef * (double)compHeight);
                int dx = x + ((int)((double)w / scaleFactor) - sdWidth) / 2;
                int dy = y + ((int)((double)h / scaleFactor) - sdHeight) / 2;
                BufferedImage thumbnail = WidgetUtilities.createThumbnail(tempCanvas, sdWidth);
                g.drawImage(thumbnail, dx, dy, (int)((double)thumbnail.getWidth() / scaleFactor), (int)((double)thumbnail.getHeight() / scaleFactor), null);
            } else {
                g.drawImage(tempCanvas, x, y, null);
            }
        }
    }

    @Override
    public boolean hasPreviewWindow(Container parent, Component component, int componentIndex) {
        return true;
    }

    @Override
    public Dimension getPreviewWindowDimension(Container parent, Component component, int componentIndex) {
        Dimension superResult = super.getPreviewWindowDimension(parent, component, componentIndex);
        if (parent instanceof JViewport) {
            Rectangle viewportRect = ((JViewport)parent).getViewRect();
            int width = Math.min(viewportRect.width / 3, superResult.width);
            int height = Math.min(viewportRect.height / 3, superResult.height);
            return new Dimension(width, height);
        }
        return superResult;
    }
}

