/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.renderer.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationAware;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationInfo;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.filters.RenderingUtils;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class SubstanceListUI
extends BasicListUI
implements UpdateOptimizationAware {
    protected Map<Integer, Object> selectedIndices = new HashMap<Integer, Object>();
    protected int rolledOverIndex = -1;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected ListSelectionListener substanceListSelectionListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    private ComponentListener substanceComponentListener;
    private StateTransitionMultiTracker<Integer> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    private ListDataListener substanceListDataListener;
    private UpdateOptimizationInfo updateInfo;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceListUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (SubstanceCoreUtilities.toDrawWatermark(this.list)) {
            this.list.setOpaque(false);
        }
        this.syncModelContents();
    }

    @Override
    protected void uninstallDefaults() {
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.stateTransitionMultiTracker.clear();
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceListSelectionListener = new SubstanceListSelectionListener();
        this.list.getSelectionModel().addListSelectionListener(this.substanceListSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.list.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.list.addMouseListener(this.substanceFadeRolloverListener);
        this.substancePropertyChangeListener = evt -> {
            if ("substancelaf.internal.watermarkVisible".equals(evt.getPropertyName())) {
                this.list.setOpaque(!SubstanceCoreUtilities.toDrawWatermark(this.list));
            }
            if ("model".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    ListModel oldModel = (ListModel)evt.getOldValue();
                    if (oldModel != null) {
                        oldModel.removeListDataListener(this.substanceListDataListener);
                    }
                    ListModel newModel = (ListModel)evt.getNewValue();
                    this.substanceListDataListener = new SubstanceListDataListener();
                    newModel.addListDataListener(this.substanceListDataListener);
                    this.syncModelContents();
                });
            }
            if ("selectionModel".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    ListSelectionModel oldModel = (ListSelectionModel)evt.getOldValue();
                    if (oldModel != null) {
                        oldModel.removeListSelectionListener(this.substanceListSelectionListener);
                    }
                    ListSelectionModel newModel = (ListSelectionModel)evt.getNewValue();
                    this.substanceListSelectionListener = new SubstanceListSelectionListener();
                    newModel.addListSelectionListener(this.substanceListSelectionListener);
                    this.syncModelContents();
                });
            }
        };
        this.list.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceComponentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                SubstanceListUI.this.fadeOutRolloverIndication();
                SubstanceListUI.this.resetRolloverIndex();
            }
        };
        this.list.addComponentListener(this.substanceComponentListener);
        this.substanceListDataListener = new SubstanceListDataListener();
        this.list.getModel().addListDataListener(this.substanceListDataListener);
    }

    @Override
    protected void uninstallListeners() {
        this.list.getModel().removeListDataListener(this.substanceListDataListener);
        this.substanceListDataListener = null;
        this.list.getSelectionModel().removeListSelectionListener(this.substanceListSelectionListener);
        this.substanceListSelectionListener = null;
        this.list.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.list.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        this.list.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.list.removeComponentListener(this.substanceComponentListener);
        this.substanceComponentListener = null;
        super.uninstallListeners();
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        JList.DropLocation dropLocation;
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        if (!(rendererComponent instanceof SubstanceDefaultListCellRenderer)) {
            super.paintCell(g, row, rowBounds, cellRenderer, dataModel, selModel, leadIndex);
            return;
        }
        boolean isWatermarkBleed = this.updateInfo.toDrawWatermark;
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.list, g));
        if (!isWatermarkBleed) {
            Color background = rendererComponent.getBackground();
            if (background != null && (!this.list.getBackground().equals(background) || this.updateInfo.isInDecorationArea)) {
                g2d.setColor(background);
                g2d.fillRect(cx, cy, cw, ch);
            }
        } else {
            BackgroundPaintingUtils.fillAndWatermark(g2d, this.list, rendererComponent.getBackground(), new Rectangle(cx, cy, cw, ch));
        }
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(row, rendererComponent);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
        ComponentState currState = modelStateInfo == null ? this.getCellState(row, rendererComponent) : modelStateInfo.getCurrModelState();
        boolean hasHighlights = false;
        if (rendererComponent.isEnabled()) {
            if (activeStates != null) {
                Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry;
                Iterator<Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo>> iterator = activeStates.entrySet().iterator();
                while (iterator.hasNext() && !(hasHighlights = this.updateInfo.getHighlightAlpha((stateEntry = iterator.next()).getKey()) * stateEntry.getValue().getContribution() > 0.0f)) {
                }
            } else {
                boolean bl = hasHighlights = this.updateInfo.getHighlightAlpha(currState) > 0.0f;
            }
        }
        if ((dropLocation = this.list.getDropLocation()) != null && !dropLocation.isInsert() && dropLocation.getIndex() == row) {
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(this.list, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, currState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.list, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, currState);
            Rectangle cellRect = new Rectangle(cx, cy, cw, ch);
            HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, cellRect, 0.8f, null, fillScheme, borderScheme);
        } else if (hasHighlights) {
            Rectangle cellRect = new Rectangle(cx, cy, cw, ch);
            if (activeStates == null) {
                float alpha = this.updateInfo.getHighlightAlpha(currState);
                if (alpha > 0.0f) {
                    SubstanceColorScheme fillScheme = this.updateInfo.getHighlightColorScheme(currState);
                    SubstanceColorScheme borderScheme = this.updateInfo.getHighlightBorderColorScheme(currState);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(this.list, alpha, g));
                    HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, cellRect, 0.8f, null, fillScheme, borderScheme);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.list, g));
                }
            } else {
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry : activeStates.entrySet()) {
                    ComponentState activeState = stateEntry.getKey();
                    float alpha = this.updateInfo.getHighlightAlpha(activeState) * stateEntry.getValue().getContribution();
                    if (alpha == 0.0f) continue;
                    SubstanceColorScheme fillScheme = this.updateInfo.getHighlightColorScheme(activeState);
                    SubstanceColorScheme borderScheme = this.updateInfo.getHighlightBorderColorScheme(activeState);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(this.list, alpha, g));
                    HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, cellRect, 0.8f, null, fillScheme, borderScheme);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.list, g));
                }
            }
        }
        this.rendererPane.paintComponent(g2d, rendererComponent, this.list, cx, cy, cw, ch, true);
        g2d.dispose();
    }

    public StateTransitionTracker getStateTransitionTracker(int row) {
        return this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)row);
    }

    public ComponentState getCellState(int cellIndex, Component rendererComponent) {
        StateTransitionTracker tracker;
        boolean isEnabled = this.list.isEnabled();
        if (rendererComponent != null) {
            boolean bl = isEnabled = isEnabled && rendererComponent.isEnabled();
        }
        if ((tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)cellIndex)) == null) {
            boolean isRollover = this.rolledOverIndex >= 0 && this.rolledOverIndex == cellIndex;
            boolean isSelected = this.selectedIndices.containsKey(cellIndex);
            return ComponentState.getState(isEnabled, isRollover, isSelected);
        }
        ComponentState fromTracker = tracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState(isEnabled, fromTracker.isFacetActive(SubstanceSlices.ComponentStateFacet.ROLLOVER), fromTracker.isFacetActive(SubstanceSlices.ComponentStateFacet.SELECTION));
    }

    public StateTransitionTracker.ModelStateInfo getModelStateInfo(int row, Component rendererComponent) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)row);
        if (tracker == null) {
            return null;
        }
        return tracker.getModelStateInfo();
    }

    public void resetRolloverIndex() {
        this.rolledOverIndex = -1;
    }

    private void fadeOutRolloverIndication() {
        if (this.rolledOverIndex < 0) {
            return;
        }
        StateTransitionTracker tracker = this.getTracker(this.rolledOverIndex, true, this.list.isSelectedIndex(this.rolledOverIndex));
        tracker.getModel().setRollover(false);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g, c);
        Graphics2D g2d = (Graphics2D)g.create();
        RenderingUtils.installDesktopHints(g2d, c);
        SubstanceStripingUtils.setup(c);
        this.updateInfo = new UpdateOptimizationInfo(c);
        this.paint(g2d, c);
        SubstanceStripingUtils.tearDown(c);
        g2d.dispose();
        this.updateInfo = null;
    }

    private void syncModelContents() {
        if (this.list == null) {
            return;
        }
        this.stateTransitionMultiTracker.clear();
        this.selectedIndices.clear();
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            if (!this.list.isSelectedIndex(i)) continue;
            this.selectedIndices.put(i, this.list.getModel().getElementAt(i));
        }
        this.list.repaint();
    }

    private StateTransitionTracker getTracker(int row, boolean initialRollover, boolean initialSelected) {
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)row);
        if (tracker == null) {
            DefaultButtonModel model = new DefaultButtonModel();
            model.setSelected(initialSelected);
            model.setRollover(initialRollover);
            tracker = new StateTransitionTracker(this.list, model);
            tracker.registerModelListeners();
            tracker.setRepaintCallback(() -> new CellRepaintCallback(this.list, row));
            tracker.setName("row " + row);
            this.stateTransitionMultiTracker.addTracker((Comparable<Integer>)row, tracker);
        }
        return tracker;
    }

    @Override
    public UpdateOptimizationInfo getUpdateOptimizationInfo() {
        return this.updateInfo;
    }

    protected class CellRepaintCallback
    extends UIThreadTimelineCallbackAdapter {
        protected JList list;
        protected int cellIndex;

        public CellRepaintCallback(JList list, int cellIndex) {
            this.list = list;
            this.cellIndex = cellIndex;
        }

        @Override
        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintCell();
        }

        @Override
        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintCell();
        }

        private void repaintCell() {
            if (SubstanceListUI.this.list == null) {
                return;
            }
            try {
                SubstanceListUI.this.maybeUpdateLayoutState();
                int cellCount = this.list.getModel().getSize();
                if (cellCount > 0 && this.cellIndex < cellCount) {
                    Rectangle rect = SubstanceListUI.this.getCellBounds(this.list, this.cellIndex, this.cellIndex);
                    this.list.repaint(rect);
                }
            }
            catch (RuntimeException re) {
                return;
            }
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SubstanceListUI.this.fadeOutRolloverIndication();
            SubstanceListUI.this.resetRolloverIndex();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!SubstanceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SubstanceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            if (!(SubstanceListUI.this.list.getCellRenderer() instanceof SubstanceDefaultListCellRenderer)) {
                SubstanceListUI.this.fadeOutRolloverIndication();
                SubstanceListUI.this.resetRolloverIndex();
                return;
            }
            int roIndex = SubstanceListUI.this.list.locationToIndex(e.getPoint());
            if (roIndex >= 0 && roIndex < SubstanceListUI.this.list.getModel().getSize() && !SubstanceListUI.this.list.getCellBounds(roIndex, roIndex).contains(e.getPoint())) {
                roIndex = -1;
            }
            if (roIndex < 0 || roIndex >= SubstanceListUI.this.list.getModel().getSize()) {
                SubstanceListUI.this.fadeOutRolloverIndication();
                SubstanceListUI.this.resetRolloverIndex();
            } else {
                if (SubstanceListUI.this.rolledOverIndex >= 0 && SubstanceListUI.this.rolledOverIndex == roIndex) {
                    return;
                }
                SubstanceListUI.this.fadeOutRolloverIndication();
                StateTransitionTracker tracker = SubstanceListUI.this.getTracker(roIndex, false, SubstanceListUI.this.list.isSelectedIndex(roIndex));
                tracker.getModel().setRollover(true);
                SubstanceListUI.this.rolledOverIndex = roIndex;
            }
        }
    }

    private final class SubstanceListDataListener
    implements ListDataListener {
        private SubstanceListDataListener() {
        }

        private void _syncModelContents() {
            SwingUtilities.invokeLater(() -> SubstanceListUI.this.syncModelContents());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this._syncModelContents();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this._syncModelContents();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this._syncModelContents();
        }
    }

    private class SubstanceListSelectionListener
    implements ListSelectionListener {
        private SubstanceListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SwingUtilities.invokeLater(() -> {
                this.handleListSelectionChange(e);
                if (SubstanceListUI.this.list != null) {
                    SubstanceListUI.this.list.repaint();
                }
            });
        }

        private void handleListSelectionChange(ListSelectionEvent e) {
            if (SubstanceListUI.this.list == null) {
                return;
            }
            if (WidgetUtilities.hasNoAnimations(SubstanceListUI.this.list, SubstanceSlices.AnimationFacet.SELECTION)) {
                return;
            }
            if (!(SubstanceListUI.this.list.getCellRenderer() instanceof SubstanceDefaultListCellRenderer)) {
                SubstanceListUI.this.syncModelContents();
                return;
            }
            HashSet<StateTransitionTracker> initiatedTrackers = new HashSet<StateTransitionTracker>();
            boolean fadeCanceled = false;
            for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                StateTransitionTracker tracker;
                if (i >= SubstanceListUI.this.list.getModel().getSize()) continue;
                if (SubstanceListUI.this.list.isSelectedIndex(i)) {
                    if (SubstanceListUI.this.selectedIndices.containsKey(i)) continue;
                    SubstanceListUI.this.selectedIndices.put(i, SubstanceListUI.this.list.getModel().getElementAt(i));
                    if (fadeCanceled) continue;
                    tracker = SubstanceListUI.this.getTracker(i, i == SubstanceListUI.this.rolledOverIndex, false);
                    tracker.getModel().setSelected(true);
                    initiatedTrackers.add(tracker);
                    if (initiatedTrackers.size() <= 25) continue;
                    SubstanceListUI.this.stateTransitionMultiTracker.clear();
                    initiatedTrackers.clear();
                    fadeCanceled = true;
                    continue;
                }
                if (!SubstanceListUI.this.selectedIndices.containsKey(i)) continue;
                if (SubstanceListUI.this.selectedIndices.get(i) == SubstanceListUI.this.list.getModel().getElementAt(i) && !fadeCanceled) {
                    tracker = SubstanceListUI.this.getTracker(i, i == SubstanceListUI.this.rolledOverIndex, true);
                    tracker.getModel().setSelected(false);
                    initiatedTrackers.add(tracker);
                    if (initiatedTrackers.size() > 25) {
                        SubstanceListUI.this.stateTransitionMultiTracker.clear();
                        initiatedTrackers.clear();
                        fadeCanceled = true;
                    }
                }
                SubstanceListUI.this.selectedIndices.remove(i);
            }
        }
    }
}

