/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;

public class SubstanceMenuBackgroundDelegate {
    public static Color getGutterSoftFillColor(SubstanceColorScheme colorScheme) {
        return colorScheme.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getExtraLightColor();
    }

    public static Color getGutterHardFillColor(SubstanceColorScheme colorScheme) {
        return colorScheme.isDark() ? SubstanceColorUtilities.getLighterColor(colorScheme.getUltraLightColor(), 0.05) : colorScheme.getUltraLightColor();
    }

    public static void paintBackground(Graphics g, JComponent menuItem, int textOffset) {
        if (!menuItem.isShowing()) {
            return;
        }
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BackgroundPaintingUtils.update(graphics, menuItem, false);
        if (textOffset == 0) {
            return;
        }
        if (menuItem.getParent() instanceof JPopupMenu) {
            boolean shouldPaintGutter;
            JPopupMenu parent = (JPopupMenu)menuItem.getParent();
            MenuUtilities.MenuLayoutMetrics popupMetrics = MenuUtilities.getPopupLayoutMetrics(parent, true);
            SubstanceSlices.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
            boolean hasGutterContent = popupMetrics.maxIconWidth > 0 || popupMetrics.maxCheckIconWidth > 0;
            boolean bl = shouldPaintGutter = hasGutterContent && fillKind != null && fillKind != SubstanceSlices.MenuGutterFillKind.NONE;
            if (shouldPaintGutter) {
                SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(menuItem, ComponentState.ENABLED);
                Color extraLight = SubstanceMenuBackgroundDelegate.getGutterHardFillColor(scheme);
                Color ultraLight = SubstanceMenuBackgroundDelegate.getGutterSoftFillColor(scheme);
                if (menuItem.getComponentOrientation().isLeftToRight()) {
                    Color leftColor = fillKind == SubstanceSlices.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceSlices.MenuGutterFillKind.HARD ? ultraLight : extraLight;
                    Color rightColor = fillKind == SubstanceSlices.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceSlices.MenuGutterFillKind.SOFT ? ultraLight : extraLight;
                    LinearGradientPaint gp = new LinearGradientPaint(0.0f, 0.0f, textOffset, 0.0f, new float[]{0.0f, 1.0f}, new Color[]{leftColor, rightColor}, MultipleGradientPaint.CycleMethod.REPEAT);
                    graphics.setComposite(WidgetUtilities.getAlphaComposite(menuItem, 0.7f, g));
                    graphics.setPaint(gp);
                    graphics.fillRect(0, 0, textOffset - 2, menuHeight);
                } else {
                    Color leftColor = fillKind == SubstanceSlices.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceSlices.MenuGutterFillKind.HARD ? extraLight : ultraLight;
                    Color rightColor = fillKind == SubstanceSlices.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceSlices.MenuGutterFillKind.SOFT ? extraLight : ultraLight;
                    LinearGradientPaint gp = new LinearGradientPaint(textOffset, 0.0f, menuWidth, 0.0f, new float[]{0.0f, 1.0f}, new Color[]{leftColor, rightColor}, MultipleGradientPaint.CycleMethod.REPEAT);
                    graphics.setComposite(WidgetUtilities.getAlphaComposite(menuItem, 0.7f, g));
                    graphics.setPaint(gp);
                    graphics.fillRect(textOffset - 2, 0, menuWidth, menuHeight);
                }
            }
        }
        graphics.dispose();
    }

    public static void paintHighlights(Graphics g, JMenuItem menuItem, float borderAlpha) {
        Graphics2D graphics = (Graphics2D)g.create();
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)menuItem.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        if (currState.isDisabled()) {
            return;
        }
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        if (currState == ComponentState.ENABLED && activeStates.size() == 1) {
            return;
        }
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry : activeStates.entrySet()) {
            ComponentState activeState = stateEntry.getKey();
            float alpha = SubstanceColorSchemeUtilities.getHighlightAlpha(menuItem, activeState) * stateEntry.getValue().getContribution();
            if (alpha == 0.0f) continue;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(menuItem, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT, activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(menuItem, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, activeState);
            graphics.setComposite(WidgetUtilities.getAlphaComposite(menuItem, alpha, g));
            HighlightPainterUtils.paintHighlight(graphics, null, menuItem, new Rectangle(0, 0, menuItem.getWidth(), menuItem.getHeight()), borderAlpha, null, fillScheme, borderScheme);
            graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)menuItem, g));
        }
        graphics.dispose();
    }
}

