/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.RootPaneContainer;
import org.osgi.framework.BundleContext;
import org.weasis.launcher.AutoProcessor;
import org.weasis.launcher.Messages;
import org.weasis.launcher.applet.WeasisFrame;

public class WeasisLoader {
    public static final String LBL_LOADING = Messages.getString("WebStartLoader.load");
    public static final String LBL_DOWNLOADING = Messages.getString("WebStartLoader.download");
    public static final String FRM_TITLE = String.format(Messages.getString("WebStartLoader.title"), System.getProperty("weasis.name"));
    public static final String PRG_STRING_FORMAT = Messages.getString("WebStartLoader.end");
    private JButton cancelButton;
    private JLabel loadingLabel;
    private volatile JProgressBar downloadProgress;
    private Container container;
    private final File resPath;
    private final WeasisFrame mainFrame;
    private final Properties localProperties;

    public WeasisLoader(File resPath, WeasisFrame mainFrame, Properties localProperties) {
        this.resPath = resPath;
        this.mainFrame = mainFrame;
        this.localProperties = localProperties;
    }

    public void writeLabel(String text) {
        this.loadingLabel.setText(text);
    }

    public void initGUI() {
        this.loadingLabel = new JLabel();
        this.loadingLabel.setFont(new Font("Dialog", 0, 10));
        this.downloadProgress = new JProgressBar();
        Font font = new Font("Dialog", 0, 12);
        this.downloadProgress.setFont(font);
        this.cancelButton = new JButton();
        this.cancelButton.setFont(font);
        RootPaneContainer frame = this.mainFrame.getRootPaneContainer();
        if (frame == null || frame instanceof JFrame) {
            Window win = new Window((Frame)((Object)frame));
            win.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    WeasisLoader.this.closing();
                }
            });
            this.container = win;
        } else {
            JPanel splashScreenPanel = new JPanel(new BorderLayout());
            frame.getContentPane().add((Component)splashScreenPanel, "Center");
            this.container = splashScreenPanel;
        }
        this.loadingLabel.setText(LBL_LOADING);
        this.loadingLabel.setFocusable(false);
        this.downloadProgress.setFocusable(false);
        this.downloadProgress.setStringPainted(true);
        this.downloadProgress.setString(LBL_LOADING);
        this.cancelButton.setText(Messages.getString("WebStartLoader.cancel"));
        this.cancelButton.addActionListener(evt -> this.closing());
        File iconFile = null;
        if (this.resPath != null && !(iconFile = new File(this.resPath, "images" + File.separator + "about.png")).canRead()) {
            iconFile = null;
        }
        Icon icon = iconFile == null ? new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }

            @Override
            public int getIconWidth() {
                return 350;
            }

            @Override
            public int getIconHeight() {
                return 75;
            }
        } : new ImageIcon(iconFile.getAbsolutePath());
        JLabel imagePane = new JLabel(FRM_TITLE, icon, 0);
        imagePane.setFont(new Font("Dialog", 1, 16));
        imagePane.setVerticalTextPosition(1);
        imagePane.setHorizontalTextPosition(0);
        imagePane.setFocusable(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        panel.add((Component)imagePane, "Center");
        JPanel panelProgress = new JPanel(new BorderLayout());
        panelProgress.setBackground(Color.WHITE);
        panelProgress.add((Component)this.loadingLabel, "North");
        panelProgress.add((Component)this.downloadProgress, "Center");
        panelProgress.add((Component)this.cancelButton, "East");
        panel.add((Component)panelProgress, "South");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.container.add((Component)panel, "Center");
        if (this.container instanceof Window) {
            ((Window)this.container).pack();
        }
    }

    public WeasisFrame getMainFrame() {
        return this.mainFrame;
    }

    public Properties getLocalProperties() {
        return this.localProperties;
    }

    public void setMax(int max) {
        if (this.isClosed()) {
            return;
        }
        EventQueue.invokeLater(() -> this.downloadProgress.setMaximum(max));
    }

    public void setValue(int val) {
        if (this.isClosed()) {
            return;
        }
        EventQueue.invokeLater(() -> {
            this.downloadProgress.setString(String.format(PRG_STRING_FORMAT, val, this.downloadProgress.getMaximum()));
            this.downloadProgress.setValue(val);
            this.downloadProgress.repaint();
        });
    }

    private void closing() {
        System.exit(0);
    }

    public boolean isClosed() {
        return this.container == null;
    }

    public void open() {
        try {
            EventQueue.invokeAndWait(() -> {
                if (this.container == null) {
                    this.initGUI();
                }
                this.displayOnScreen();
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        EventQueue.invokeLater(() -> {
            this.container.setVisible(false);
            if (this.container.getParent() != null) {
                this.container.getParent().remove(this.container);
            }
            if (this.container instanceof Window) {
                ((Window)this.container).dispose();
            }
            this.container = null;
            this.cancelButton = null;
            this.downloadProgress = null;
            this.loadingLabel = null;
        });
    }

    private void displayOnScreen() {
        if (this.container instanceof Window) {
            try {
                Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
                int x = bounds.x + (bounds.width - this.container.getWidth()) / 2;
                int y = bounds.y + (bounds.height - this.container.getHeight()) / 2;
                this.container.setLocation(x, y);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.container.setVisible(true);
        }
    }

    public void setFelix(Map<String, String> serverProp, BundleContext bundleContext) {
        AutoProcessor.process(serverProp, bundleContext, this);
    }
}

